{
    'name': 'Apollo Package Management',
    'version': '18.0.1.0.0',
    'category': 'Administration',
    'summary': '额度驱动的套餐权限管理系统',
    'description': """
Apollo Package Management System
================================

基于额度驱动的套餐权限管理系统，支持：

核心功能：
* 灵活的套餐配置和管理
* 额度定义和权限控制
* 组织级别的套餐订阅
* 个性化额度调整
* 套餐时长延长管理
* 额度使用情况跟踪

主要特性：
* 无限扩展的套餐类型
* 基于额度的权限检查
* 支持扩展套餐
* 灵活的定价策略
* 完整的审计追踪
* 基于组织的权限继承

技术特点：
* 配置化权限管理
* 统一的权限检查逻辑
* 支持临时额度调整
* 多种调整类型（增加/设置/倍数）
* Odoo风格的管理界面
    """,
    'author': 'Apollo Team',
    'website': 'https://apollo.com',
    'depends': [
        'base',
        'apollo_account',  # 依赖组织管理模块
    ],
    'data': [
        # Security
        'security/apollo_package_groups.xml',
        'security/ir.model.access.csv',
        
        # Data
        'data/feature_modules_data.xml',
        'data/quota_definitions_data.xml',
        
        # Views (按依赖关系排序)
        'views/package_quota_views.xml',
        'views/package_quota_history_views.xml',
        'views/package_pricing_views.xml',
        'views/package_pricing_change_log_views.xml',
        'views/organization_quota_adjustment_views.xml',
        'views/organization_subscription_extension_views.xml',
        'views/organization_quota_usage_views.xml',
        'views/quota_definition_views.xml',
        'views/feature_module_views.xml',
        'views/organization_package_subscription_views.xml',
        
        # Wizards (必须在package_views.xml之前加载)
        'wizard/batch_add_quota_views.xml',
        'wizard/edit_quota_wizard_views.xml',
        'wizard/quick_add_pricing_wizard_views.xml',
        'wizard/pricing_change_wizard_views.xml',
        'wizard/organization_package_config_wizard_views.xml',
        'views/package_views.xml',
        
        # Organization Extensions (扩展apollo_account的组织视图)
        'views/organization_extension_views.xml',
        
        # Menus
        'views/apollo_package_menus.xml',
    ],
    'demo': [
        'demo/demo_data.xml',
    ],
    'installable': True,
    'auto_install': False,
    'application': True,
    'license': 'LGPL-3',
}
