# 业务管理员权限实现说明

## 概述
本文档描述了为 Apollo Account 模块添加业务管理员权限的实现细节。业务管理员拥有对所有组织的完全管理权限。

## 实现的功能

### 1. 新增模块分类和安全组
#### Apollo 模块分类
- **分类名称**: `Apollo`
- **技术名称**: `apollo_account.module_category_apollo`
- **描述**: Apollo 系统相关的权限组
- **序列**: 10

#### 业务管理员安全组
- **组名称**: `Apollo Business Administrator`
- **技术名称**: `apollo_account.group_apollo_business_admin`
- **分类**: Apollo
- **权限继承**: 继承组织所有者组的所有权限

#### 权限组分类调整
所有 Apollo 相关的权限组都已移动到新的 Apollo 分类下：
- Apollo Organization Owner (组织所有者)
- Apollo Organization Member (组织成员)  
- Apollo Business Administrator (业务管理员)

### 2. 访问规则 (Record Rules)
为所有相关模型添加了业务管理员的完全访问权限：

- `apollo.organization` - 所有组织的完全权限
- `apollo.organization.member` - 所有成员记录的完全权限
- `apollo.organization.owner.change` - 所有所有者变更记录的完全权限
- `apollo.invitation.code` - 所有邀请码的完全权限
- `apollo.sms.verification.code` - 所有短信验证码的完全权限

所有规则使用 `[(1, '=', 1)]` 域过滤器，表示无条件访问所有记录。

### 3. 模型访问权限 (Model Access)
在 `ir.model.access.csv` 中为业务管理员组添加了对所有模型的完全访问权限：
- 读取 (Read): ✓
- 写入 (Write): ✓
- 创建 (Create): ✓
- 删除 (Unlink): ✓

### 4. 权限检查方法更新

#### Apollo Organization 模型
- 新增 `is_user_business_admin()` 辅助方法
- 更新 `check_user_access()` 方法，业务管理员拥有所有权限
- 更新 `assign_user_groups()` 方法，避免为业务管理员分配低级别组
- 更新 `remove_user_groups()` 方法，保护业务管理员的组权限

#### Apollo Organization Member 模型
- 更新 `check_user_access()` 方法，支持业务管理员权限

### 5. 用户组管理优化
- 业务管理员不会被分配组织所有者或成员组
- 从组织中移除业务管理员时，不会移除其业务管理员组
- 自动跳过对业务管理员的组权限管理

## 权限层级结构

```
业务管理员 (最高权限)
    ↓ 继承
组织所有者
    ↓ 继承  
组织成员
    ↓ 继承
基础用户
```

## 使用方法

### 1. 分配业务管理员权限
1. 进入 **设置** > **用户和公司** > **用户**
2. 选择要设置为业务管理员的用户
3. 在 **访问权限** 标签页中，勾选 **Apollo Business Administrator** 组

### 2. 业务管理员功能
业务管理员可以：
- 查看和管理所有组织
- 添加/移除任何组织的成员
- 修改任何组织的所有者
- 管理所有邀请码
- 查看所有组织的历史记录
- 执行所有组织相关的操作

### 3. 权限验证
系统会自动识别业务管理员身份，无需额外配置。所有权限检查方法都已更新以支持业务管理员。

## 安全考虑

1. **最小权限原则**: 只有真正需要管理所有组织的用户才应该被分配业务管理员权限
2. **审计跟踪**: 所有业务管理员的操作都会被记录在相应的历史记录中
3. **权限隔离**: 业务管理员权限独立于系统管理员权限，避免权限过度集中

## 技术细节

### 依赖关系
- 继承 `apollo_account.group_apollo_organization_owner`
- 使用自定义 `apollo_account.module_category_apollo` 分类

### 域过滤器
所有业务管理员访问规则使用 `[(1, '=', 1)]`，这是 Odoo 中表示"无条件访问"的标准写法。

### 向后兼容性
- 现有的组织所有者和成员权限保持不变
- 不影响现有用户的权限设置
- 可以安全地升级现有系统

## 测试建议

1. 创建测试用户并分配业务管理员权限
2. 验证可以访问所有组织
3. 测试各种操作（创建、修改、删除）
4. 确认权限检查方法正常工作
5. 验证用户组管理逻辑正确

## 维护说明

如果需要修改业务管理员权限：
1. 更新相应的访问规则
2. 修改权限检查方法
3. 测试所有相关功能
4. 更新文档
