# Apollo Account Management System

一个为Odoo 18设计的现代化账户管理系统，提供组织管理、邀请码系统、短信验证和JWT认证功能。

## 🏗️ 架构设计

### 模块化架构
```
apollo_account/
├── controllers/           # API控制器层
│   ├── api/              # RESTful API端点
│   │   ├── auth_api.py   # 用户认证API
│   │   ├── invitation_api.py # 邀请码API
│   │   └── sms_api.py    # 短信验证API
│   └── base_api_controller.py # API基类
├── models/               # 数据模型层
│   ├── apollo_organization.py # 组织模型
│   ├── invitation_code.py     # 邀请码模型
│   └── sms_verification_code.py # 短信验证码模型
├── services/             # 业务服务层
│   ├── jwt_service.py    # JWT令牌服务
│   └── sms_service.py    # 短信发送服务
├── utils/                # 工具函数层
│   ├── validators.py     # 数据验证器
│   └── helpers.py        # 辅助函数
├── wizard/               # 向导界面
└── views/                # 视图定义
```

### 设计原则

1. **关注点分离**: 控制器、模型、服务和工具分层设计
2. **单一职责**: 每个类和方法都有明确的单一职责
3. **可扩展性**: 模块化设计便于功能扩展
4. **安全性**: 全面的数据验证和错误处理
5. **可维护性**: 清晰的代码结构和完整的文档

## 🚀 核心功能

### 1. 组织管理
- 创建和管理组织
- 组织所有者管理
- 成员关系维护
- 组织Logo和基本信息

### 2. 邀请码系统
- 自动生成唯一邀请码
- 手机号绑定和验证
- 邀请码状态管理（有效/已使用/已作废）
- 用户绑定和组织成员创建

### 3. 短信验证
- 6位数字验证码生成
- 支持邀请注册和登录两种验证码类型
- 发送冷却期控制（2分钟）
- 验证码过期管理（5分钟）
- 多种短信服务商支持

### 4. JWT认证
- 安全的令牌生成和验证
- 多种登录方式：密码登录、短信验证码登录
- 支持手机号或邮箱登录
- 登录和注册状态管理
- 令牌刷新机制
- 用户信息加密存储

## 📡 API接口

### API路由概览

#### 邀请码管理
- `POST /api/apollo/invitation/info` - 获取邀请码信息
- `POST /api/apollo/invitation/create` - 创建邀请码
- `POST /api/apollo/invitation/void` - 作废邀请码

#### 短信验证码服务
- `POST /api/apollo/sms/send_invitation_code` - 发送邀请注册验证码
- `POST /api/apollo/sms/verify_invitation_code` - 验证邀请注册短信码
- `POST /api/apollo/sms/send_login_code` - 发送登录验证码
- `POST /api/apollo/sms/verify_login_code` - 验证登录短信码

#### 用户认证服务
- `POST /api/apollo/jwt/verify` - 验证JWT令牌
- `POST /api/apollo/user/login` - 密码登录
- `POST /api/apollo/user/login/sms` - 短信验证码登录
- `POST /api/apollo/user/register` - 用户注册
- `POST /api/apollo/user/profile` - 获取用户资料

### 邀请码管理

#### 获取邀请码信息
```http
POST /api/apollo/invitation/info
Content-Type: application/json

{
    "invitation_code": "ABCD1234EFGH"
}
```

#### 创建邀请码
```http
POST /api/apollo/invitation/create
Content-Type: application/json
Authorization: Required

{
    "organization_id": 1,
    "phone": "13800138000"
}
```

#### 作废邀请码
```http
POST /api/apollo/invitation/void
Content-Type: application/json
Authorization: Required

{
    "invitation_code": "ABCD1234EFGH"
}
```

### 短信验证

#### 发送邀请注册验证码
```http
POST /api/apollo/sms/send_invitation_code
Content-Type: application/json

{
    "invitation_code": "ABCD1234EFGH"
}
```

#### 发送登录验证码
```http
POST /api/apollo/sms/send_login_code
Content-Type: application/json

{
    "phone": "13800138000"
}
```

#### 验证邀请注册短信码
```http
POST /api/apollo/sms/verify_invitation_code
Content-Type: application/json

{
    "invitation_code": "ABCD1234EFGH",
    "sms_code": "123456"
}
```

**响应说明：**
- 如果用户已注册：返回登录令牌，`user_exists: true`，`status: 'login_success'`，自动绑定邀请码并加入新组织
- 如果用户未注册：返回注册令牌，`user_exists: false`，`status: 'registration_pending'`

**多组织支持：**
- 用户可以同时属于多个组织
- 通过邀请码可以加入新组织，无需重复注册
- 系统自动维护用户在各组织中的成员关系

#### 验证登录短信码
```http
POST /api/apollo/sms/verify_login_code
Content-Type: application/json

{
    "phone": "13800138000",
    "sms_code": "123456"
}
```

### 用户认证

#### 验证JWT令牌
```http
POST /api/apollo/jwt/verify
Content-Type: application/json

{
    "token": "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9..."
}
```

#### 密码登录
```http
POST /api/apollo/user/login
Content-Type: application/json

{
    "phone": "13800138000",    // 手机号（可选）
    "email": "user@example.com", // 邮箱（可选）
    "password": "用户密码"      // 必需，至少提供phone或email之一
}
```

#### 短信验证码登录
```http
POST /api/apollo/user/login/sms
Content-Type: application/json

{
    "phone": "13800138000",
    "sms_code": "123456"
}
```

#### 用户注册
```http
POST /api/apollo/user/register
Content-Type: application/json

{
    "token": "registration_token",  // JWT令牌（包含organization_id）
    "name": "张三",
    "password": "用户密码"          // 新增必需参数
}
```

#### 获取用户个人资料
```http
POST /api/apollo/user/profile
Content-Type: application/json

{
    "token": "login_token"
}
```

#### 获取用户组织资料
```http
POST /api/apollo/user/organizations
Content-Type: application/json

{
    "token": "login_token"
}
```

## 🛠️ 技术特性

### 数据验证
- 手机号格式验证（支持中国大陆号码）
- 邀请码格式验证（12位字母数字组合）
- 用户输入数据清理和标准化
- 全面的错误处理和用户友好的错误消息

### 安全控制
- 短信发送频率限制
- JWT令牌过期管理
- 敏感数据掩码处理
- IP地址和用户代理记录

### 性能优化
- 数据库索引优化
- 计算字段缓存
- 批量操作支持
- 异步处理支持

### 扩展性
- 插件化的短信服务商支持
- 可配置的验证规则
- 灵活的权限控制
- 标准化的API响应格式

## 📦 安装和配置

### 1. 安装依赖
```bash
pip install PyJWT
```

### 2. 模块安装
1. 将模块放入Odoo的addons目录
2. 在Odoo中激活开发者模式
3. 更新应用列表
4. 搜索并安装"Apollo Account"模块

### 3. 配置参数
在系统参数中配置以下参数：
- `apollo.jwt.secret`: JWT密钥（生产环境必须修改）
- `apollo.sms.provider`: 短信服务商（aliyun/tencent/custom/mock）

## 🔧 开发指南

### 添加新的API端点
1. 在`controllers/api/`目录下创建新的控制器
2. 继承`BaseApiController`类
3. 使用标准的响应格式
4. 添加适当的验证和错误处理

### 扩展短信服务商
1. 在`services/sms_service.py`中添加新的发送方法
2. 实现`_send_via_xxx`方法
3. 在配置中添加新的provider选项

### 自定义验证器
1. 在`utils/validators.py`中添加新的验证器类
2. 实现验证逻辑
3. 在API控制器中使用验证器

## 🧪 测试

### API测试示例
```bash
# 获取邀请码信息
curl -X POST http://localhost:8069/api/apollo/invitation/info \
  -H "Content-Type: application/json" \
  -d '{"invitation_code": "ABCD1234EFGH"}'

# 发送邀请注册验证码
curl -X POST http://localhost:8069/api/apollo/sms/send_invitation_code \
  -H "Content-Type: application/json" \
  -d '{"invitation_code": "ABCD1234EFGH"}'

# 发送登录验证码
curl -X POST http://localhost:8069/api/apollo/sms/send_login_code \
  -H "Content-Type: application/json" \
  -d '{"phone": "13800138000"}'

# 密码登录
curl -X POST http://localhost:8069/api/apollo/user/login \
  -H "Content-Type: application/json" \
  -d '{"phone": "13800138000", "password": "your_password"}'

# 短信验证码登录
curl -X POST http://localhost:8069/api/apollo/user/login/sms \
  -H "Content-Type: application/json" \
  -d '{"phone": "13800138000", "sms_code": "123456"}'
```

## 📊 数据模型

### apollo.organization (组织)
- `name`: 组织名称
- `logo`: 组织Logo
- `owner_id`: 组织所有者
- `active`: 激活状态

### apollo.invitation.code (邀请码)
- `code`: 12位唯一邀请码
- `phone`: 绑定手机号
- `organization_id`: 关联组织
- `status`: 状态（有效/已使用/已作废）
- `bound_user_id`: 绑定用户

### apollo.sms.verification.code (短信验证码)
- `phone`: 手机号
- `code`: 6位验证码
- `verification_type`: 验证类型（invitation/login）
- `invitation_code`: 关联邀请码（邀请类型时）
- `expires_at`: 过期时间
- `is_used`: 是否已使用

## 🔒 权限管理

默认权限配置：
- 所有登录用户可以创建和管理邀请码
- 公开API端点无需认证
- 管理员可以查看所有统计信息

## 📈 监控和统计

### 短信发送统计
- 总发送量
- 成功率
- 使用率
- 按组织分组统计

### 邀请码使用统计
- 创建数量
- 使用率
- 作废数量
- 按时间段统计

## 🤝 贡献指南

1. Fork项目
2. 创建功能分支
3. 提交更改
4. 推送到分支
5. 创建Pull Request

## 📄 许可证

本项目采用LGPL-3许可证。

## 🆘 支持

如有问题或建议，请：
1. 查看文档和FAQ
2. 搜索已知问题
3. 创建新的Issue
4. 联系技术支持

---

**Apollo Account Management System** - 为现代应用构建的强大账户管理解决方案。