# Apollo Account 权限控制说明

## 概述

本模块实现了基于组织的权限控制系统，确保用户只能访问和操作自己有权限的数据。

## 权限模型

### 安全组

1. **Apollo Organization Owner** (`group_apollo_organization_owner`)
   - 组织所有者组
   - 可以管理自己拥有的组织和相关的所有模型
   - 继承组织成员组的权限

2. **Apollo Organization Member** (`group_apollo_organization_member`)
   - 组织成员组
   - 只能查看自己所在组织和组织下的成员信息
   - 继承基础用户组权限

### 权限规则

#### 组织所有者权限
- **Apollo Organization**: 完全访问自己拥有的组织 (CRUD)
- **Apollo Organization Member**: 完全访问自己组织的成员记录 (CRU，不能删除)
- **Apollo Organization Owner Change**: 可以查看和创建自己组织的所有者变更记录
- **Apollo Invitation Code**: 完全访问自己组织的邀请码 (CRUD)
- **Apollo SMS Verification Code**: 无权访问（仅系统管理员）

#### 组织成员权限
- **Apollo Organization**: 只能查看自己所在的组织 (R)
- **Apollo Organization Member**: 只能查看自己所在组织的成员记录 (R)
- **Apollo Organization Owner Change**: 无权访问
- **Apollo Invitation Code**: 无权访问
- **Apollo SMS Verification Code**: 无权访问

## 技术实现

### 多对多字段
```python
current_user_ids = fields.Many2many(
    'res.users',
    'apollo_organization_user_rel',
    'organization_id',
    'user_id',
    string='当前用户',
    compute='_compute_current_user_ids',
    store=True,
    help='组织中的当前用户，用于权限控制'
)
```

### 权限检查方法
- `is_user_owner(user)`: 检查用户是否为组织所有者
- `is_user_member(user)`: 检查用户是否为组织成员
- `check_user_access(access_type, user)`: 检查用户对组织的访问权限

### 自动用户组管理
- 当用户成为组织所有者时，自动分配所有者组
- 当用户加入组织时，自动分配成员组
- 当用户离开组织时，如果不在其他组织中，自动移除相关组

## 记录规则

使用 Odoo 的记录规则 (ir.rule) 实现数据级别的权限控制：

1. **域过滤**: 基于用户与组织的关系过滤可访问的记录
2. **权限控制**: 分别控制读、写、创建、删除权限
3. **安全隔离**: 确保用户只能访问自己有权限的数据

## 使用说明

### 设置组织所有者
1. 创建组织后，使用 `change_owner_wizard()` 设置所有者
2. 系统会自动为所有者分配相应的安全组

### 添加组织成员
1. 使用 `add_member_wizard()` 添加成员
2. 系统会自动为成员分配相应的安全组
3. 成员会自动添加到 `current_user_ids` 字段中

### 权限验证
```python
# 检查用户是否为组织所有者
if organization.is_user_owner():
    # 执行所有者操作

# 检查用户是否有写权限
if organization.check_user_access('write'):
    # 执行写操作
```

## 安全注意事项

1. **敏感数据保护**: 验证码、邀请码等敏感数据只有相应权限的用户才能访问
2. **数据隔离**: 不同组织的数据完全隔离，用户无法跨组织访问
3. **权限最小化**: 普通成员只有最基本的查看权限
4. **审计跟踪**: 所有者变更等关键操作都有完整的审计记录
