# -*- coding: utf-8 -*-
# Part of Odoo. See LICENSE file for full copyright and licensing details.


{
    'name': 'Apollo Account',
    'version': '1.0',
    'category': 'Apollo',
    'description': """Apollo Account Management System
    
    A comprehensive account management system for Apollo platform with:
    
    Core Features:
    * Organization management with hierarchical structure
    * Invitation code system for user onboarding
    * SMS verification with security controls
    * JWT-based authentication and authorization
    * RESTful API endpoints for mobile/web integration
    
    Technical Highlights:
    * Modular architecture with separated concerns
    * Comprehensive validation and error handling
    * Security-first design with rate limiting
    * Extensible service layer architecture
    * Clean API design following REST principles
    
    API Endpoints:
    * Invitation management (create, void, info)
    * SMS verification (send, verify codes)
    * User authentication (login, register, profile)
    * JWT token management (verify, refresh)
    """,
    'depends': [
        'base',
        'web',
    ],
    'external_dependencies': {
        'python': ['PyJWT'],
    },
    'data': [
        'security/apollo_account_groups.xml',
        'security/apollo_account_security.xml',
        'security/ir.model.access.csv',
        'views/apollo_organization.xml',
        'views/apollo_organization_owner_change.xml',
        'views/apollo_organization_owner_change_wizard.xml',
        'views/apollo_organization_member.xml',
        'views/apollo_organization_member_wizard.xml',
        'views/invitation_code.xml',
        'views/invitation_code_wizard.xml',
        'views/sms_verification_code.xml',
    ],
    'demo': [
    ],
    'assets': {
    },
    'installable': True,
    'auto_install': False,
    'license': 'LGPL-3',
    'application': True,
}
