from odoo import api, fields, models, _
from odoo.exceptions import ValidationError


class InvitationCodeWizard(models.TransientModel):
    _name = 'apollo.invitation.code.wizard'
    _description = '生成邀请码向导'

    organization_id = fields.Many2one('apollo.organization', string='组织', required=True)
    phone = fields.Char(string='手机号', required=True)
    
    @api.constrains('phone')
    def _check_phone(self):
        """验证手机号格式"""
        for record in self:
            if record.phone and not record.phone.isdigit():
                raise ValidationError(_('手机号只能包含数字'))
            if record.phone and len(record.phone) != 11:
                raise ValidationError(_('手机号必须为11位数字'))
    
    def generate_code(self):
        """生成邀请码"""
        if not self.organization_id:
            raise ValidationError(_('请选择组织'))
        
        # 检查该手机号是否已经在该组织下有未使用的邀请码
        existing_code = self.env['apollo.invitation.code'].search([
            ('phone', '=', self.phone),
            ('organization_id', '=', self.organization_id.id),
            ('voided', '=', False),
            ('active', '=', True)
        ], limit=1)
        
        if existing_code:
            raise ValidationError(_('该手机号在此组织下已有未使用的邀请码：%s') % existing_code.code)
        
        # 创建新的邀请码
        invitation_code = self.env['apollo.invitation.code'].create({
            'phone': self.phone,
            'organization_id': self.organization_id.id,
        })
        
        # 返回创建的邀请码视图
        return {
            'name': _('邀请码已生成'),
            'type': 'ir.actions.act_window',
            'res_model': 'apollo.invitation.code',
            'res_id': invitation_code.id,
            'view_mode': 'form',
            'target': 'current',
        }
