# Apollo Frontend

Apollo Account 管理系统的前端用户界面。

## 功能特性

### 🌐 用户界面
- **响应式设计**: 支持桌面端和移动端
- **现代化UI**: 采用渐变色彩和流畅动画
- **用户友好**: 简洁直观的操作流程

### 🔐 认证功能
- **邀请码注册**: 通过邀请码完成用户注册
- **多种登录方式**: 支持密码登录和短信验证码登录
- **JWT令牌管理**: 安全的令牌存储和验证

### 📱 短信验证
- **邀请注册验证**: 邀请码绑定手机号验证
- **登录验证**: 短信验证码快速登录
- **智能防刷**: 发送频率限制和倒计时

### 👤 用户中心
- **个人信息展示**: 姓名、手机、邮箱等基础信息
- **组织信息**: 所属组织和成员角色
- **令牌信息**: JWT令牌状态和过期时间

## 页面路由

- `/apollo` - 首页（重定向到登录或用户信息）
- `/apollo/login` - 用户登录页面
- `/apollo/register` - 用户注册页面（支持邀请码参数）
- `/apollo/profile` - 用户信息页面

## API 集成

完全基于 `apollo_account` 模块提供的 RESTful API：

### 认证接口
- `POST /api/apollo/user/login` - 密码登录
- `POST /api/apollo/user/login/sms` - 短信验证码登录
- `POST /api/apollo/user/register` - 用户注册
- `POST /api/apollo/user/profile` - 获取用户个人资料
- `POST /api/apollo/user/organizations` - 获取用户组织资料

### 邀请码接口
- `POST /api/apollo/invitation/info` - 获取邀请码信息

### 短信验证接口
- `POST /api/apollo/sms/send_invitation_code` - 发送邀请注册验证码
- `POST /api/apollo/sms/verify_invitation_code` - 验证邀请注册短信码
- `POST /api/apollo/sms/send_login_code` - 发送登录验证码

### JWT接口
- `POST /api/apollo/jwt/verify` - 验证JWT令牌

## 使用流程

### 邀请注册流程
1. **验证邀请码**: 输入12位邀请码获取组织信息
2. **短信验证**: 向邀请码绑定的手机号发送验证码
3. **智能识别**: 
   - **已注册用户**: 自动绑定邀请码并登录，无需重复填写信息
   - **新用户**: 继续注册流程，设置姓名和密码

### 登录流程
1. **密码登录**: 使用手机号/邮箱 + 密码登录
2. **短信登录**: 使用手机号 + 短信验证码登录

### 用户中心
- 查看个人基础信息
- **多组织管理**：显示用户所属的所有组织
- 查看在每个组织中的角色（所有者/成员）
- 查看加入各组织的时间
- 查看JWT令牌状态
- 安全退出登录

## 技术特性

### 前端技术
- **纯JavaScript**: 无外部框架依赖
- **CSS3**: 现代化样式和动画
- **HTML5**: 语义化标签和表单验证
- **响应式布局**: 支持各种屏幕尺寸

### 数据存储
- **localStorage**: 安全存储JWT令牌和用户信息
- **自动清理**: 退出登录时清除所有本地数据

### 安全性
- **令牌验证**: 自动检查JWT令牌有效性
- **页面保护**: 未登录自动跳转到登录页
- **错误处理**: 完善的错误提示和处理机制

## 安装和配置

### 依赖模块
- `base` - Odoo基础模块
- `web` - Odoo Web框架
- `apollo_account` - Apollo账户管理模块

### 安装步骤
1. 确保 `apollo_account` 模块已安装
2. 将 `apollo_frontend` 模块放入addons目录
3. 更新应用列表
4. 安装 Apollo Frontend 模块

### 配置说明
- 模块安装后即可使用，无需额外配置
- 所有API请求都会自动路由到 `apollo_account` 的接口
- 前端界面自适应当前域名和端口

## 自定义和扩展

### 样式定制
- 修改 `static/src/css/apollo_frontend.css` 自定义样式
- 支持CSS变量，方便主题定制

### 功能扩展
- 在 `static/src/js/apollo_frontend.js` 中添加新功能
- 支持模块化开发，可分离不同页面的逻辑

### 页面定制
- 修改 `templates/apollo_frontend_templates.xml` 自定义页面结构
- 支持Odoo模板继承和重写

## 兼容性

- **Odoo版本**: 18.0+
- **浏览器支持**: Chrome 60+, Firefox 55+, Safari 12+, Edge 79+
- **移动端**: iOS Safari 12+, Android Chrome 60+

## 开发调试

### 开启调试
在浏览器控制台中可以使用：
```javascript
// 查看当前存储的令牌
ApolloUtils.getToken()

// 查看用户信息
ApolloUtils.getUserInfo()

// 手动显示消息
ApolloUtils.showMessage('测试消息', 'info')
```

### 常见问题
1. **API请求失败**: 检查 `apollo_account` 模块是否正确安装
2. **样式异常**: 清除浏览器缓存后重试
3. **令牌失效**: 检查JWT令牌是否过期

## 更新日志

### v1.0.0
- 初始版本发布
- 实现邀请码注册流程
- 实现密码和短信登录
- 实现用户信息展示
- 响应式界面设计

## 许可证

本项目采用 LGPL-3 许可证。

## 技术支持

如遇问题请：
1. 检查 `apollo_account` 模块是否正常工作
2. 查看浏览器控制台错误信息
3. 检查Odoo日志中的相关错误
4. 联系技术支持团队
