# -*- coding: utf-8 -*-
# Part of Odoo. See LICENSE file for full copyright and licensing details.

{
    'name': 'Apollo Frontend',
    'version': '1.0',
    'category': 'Apollo',
    'summary': 'Apollo Account 前端应用',
    'description': """
Apollo Frontend Application

提供基于 Apollo Account 系统的前端用户界面，包括：

核心功能：
* 邀请码注册界面
* 用户登录界面（密码登录 + 短信验证码登录）
* 用户信息展示页面
* 组织信息展示
* JWT 令牌管理

技术特性：
* 响应式前端设计
* 完全基于 Apollo Account API
* 现代化的用户界面
* 移动端友好
* 安全的令牌处理

页面包含：
* /apollo - 首页/登录页
* /apollo/register - 注册页面
* /apollo/profile - 用户信息页面
    """,
    'depends': [
        'base',
        'web',
        'apollo_account',
    ],
    'data': [
        'security/ir.model.access.csv',
        'templates/apollo_frontend_templates.xml',
    ],
    'assets': {
        'web.assets_frontend': [
            'apollo_frontend/static/src/css/apollo_frontend.css',
            'apollo_frontend/static/src/js/apollo_api.js',
            'apollo_frontend/static/src/js/login_page.js',
            'apollo_frontend/static/src/js/register_page.js',
            'apollo_frontend/static/src/js/profile_page.js',
            'apollo_frontend/static/src/js/apollo_components.js',
        ],
    },
    'installable': True,
    'auto_install': False,
    'license': 'LGPL-3',
    'application': True,
}
