# -*- coding: utf-8 -*-

from odoo import http
from odoo.http import request
import json
import logging

_logger = logging.getLogger(__name__)


class ApolloFrontendController(http.Controller):
    """Apollo Frontend 页面控制器"""

    @http.route('/apollo', type='http', auth="public", website=True, csrf=False)
    def index(self, **kwargs):
        """首页/登录页"""
        return request.render('apollo_frontend.login_page', {
            'page_title': 'Apollo 登录',
            'page_type': 'login'
        })

    @http.route('/apollo/login', type='http', auth="public", website=True, csrf=False)
    def login_page(self, **kwargs):
        """登录页面"""
        return request.render('apollo_frontend.login_page', {
            'page_title': 'Apollo 登录',
            'page_type': 'login'
        })

    @http.route('/apollo/register', type='http', auth="public", website=True, csrf=False)
    def register_page(self, invitation_code=None, **kwargs):
        """注册页面"""
        context = {
            'page_title': 'Apollo 注册',
            'page_type': 'register',
            'invitation_code': invitation_code or ''
        }
        return request.render('apollo_frontend.register_page', context)

    @http.route('/apollo/profile', type='http', auth="public", website=True, csrf=False)
    def profile_page(self, **kwargs):
        """用户信息页面"""
        return request.render('apollo_frontend.profile_page', {
            'page_title': 'Apollo 用户信息',
            'page_type': 'profile'
        })

    @http.route('/apollo/logout', type='http', auth="public", website=True, csrf=False)
    def logout(self, **kwargs):
        """退出登录"""
        # 这里只是前端清除token，重定向到登录页
        return request.redirect('/apollo/login')

    # API 代理接口（可选，用于避免跨域问题）
    @http.route('/apollo/api/proxy', type='json', auth="public", csrf=False, methods=['POST'])
    def api_proxy(self, **kwargs):
        """API 代理接口，转发请求到 apollo_account 的 API"""
        try:
            data = request.jsonrequest
            endpoint = data.get('endpoint', '')
            payload = data.get('payload', {})
            
            # 这里可以添加请求转发逻辑
            # 但由于我们直接在前端调用 API，这个接口暂时保留
            
            return {
                'success': True,
                'message': 'API Proxy ready',
                'data': {
                    'endpoint': endpoint,
                    'payload': payload
                }
            }
        except Exception as e:
            _logger.error(f"API Proxy Error: {str(e)}")
            return {
                'success': False,
                'message': 'API代理错误',
                'error': str(e)
            }
