/**
 * Apollo Frontend 组件注册
 */

import { registry } from "@web/core/registry";
import { ApolloLoginPage } from "./login_page";
import { ApolloRegisterPage } from "./register_page";
import { ApolloProfilePage } from "./profile_page";

// 注册公共组件
const publicComponentRegistry = registry.category("public_components");

publicComponentRegistry
    .add("apollo_login_page", ApolloLoginPage)
    .add("apollo_register_page", ApolloRegisterPage)
    .add("apollo_profile_page", ApolloProfilePage);
