# 定价修改记录功能说明

## 功能概述

本功能实现了对套餐定价的完整修改控制和审计追踪，确保所有定价变更都有完整的记录。

## 主要特性

### 1. 禁止直接编辑定价
- 所有定价字段（价格、货币、生效日期、失效日期、定制定价标记）都设置为只读
- 用户无法直接在表单中修改定价信息
- 必须通过专门的"修改定价"向导进行修改

### 2. 定价修改向导
- 提供专门的向导界面进行定价修改
- 显示当前值和新值的对比
- 实时计算价格变化金额和百分比
- 要求填写变更原因和备注
- 支持多种预定义的变更原因类型

### 3. 完整的变更记录
- 自动记录所有定价变更（创建、修改、删除）
- 记录变更前后的所有字段值
- 记录操作用户、时间、原因
- 提供变更摘要和统计分析

### 4. 审计追踪
- 每个定价记录关联完整的变更历史
- 支持查看单个定价的所有变更记录
- 提供全局的定价变更记录查询
- 支持按时间、用户、套餐等维度筛选

## 新增模型

### `apollo.package.pricing.change.log` - 定价修改记录
记录所有定价变更的详细信息，包括：
- 变更类型（新建/修改/删除/激活/停用）
- 变更前后的值对比
- 操作用户和时间
- 变更原因和备注
- 自动计算的统计信息

### `apollo.pricing.change.wizard` - 定价修改向导
提供用户友好的定价修改界面，包括：
- 当前值显示
- 新值输入
- 变化分析
- 原因选择和备注

## 使用流程

### 修改现有定价
1. 在套餐定价列表或表单中点击"修改定价"按钮
2. 在向导中填写新的定价信息
3. 选择变更原因并填写备注
4. 确认修改

### 查看变更记录
1. 在定价表单中点击"变更记录"统计按钮
2. 或通过菜单"定价变更记录"查看全局记录
3. 支持多种筛选和分组方式

### 创建新定价
1. 使用"快速添加定价"向导创建新定价
2. 系统自动记录创建操作
3. 记录创建原因为"通过快速添加向导创建"

## 安全控制

### 权限设置
- 定价变更记录：只读权限，用户可查看但不能修改或删除
- 定价修改向导：完整权限，允许套餐管理员使用
- 套餐定价：保持现有权限结构

### 数据完整性
- 所有变更记录都是只读的，确保审计追踪的完整性
- 变更向导包含完整的数据验证
- 防止重叠定价和无效日期范围

## 技术特点

### 自动化记录
- 重写了 `PackagePricing` 模型的 `create()` 和 `unlink()` 方法
- 所有定价变更都会自动创建记录
- 无需手动干预

### 字段映射
- 完整记录所有定价字段的变更
- 支持新旧值对比
- 自动计算变化量和百分比

### 用户体验
- 清晰的界面设计
- 实时的变化预览
- 友好的错误提示和验证

## 菜单结构

```
套餐
├── 套餐定价              (修改后包含"修改定价"按钮)
├── 定价变更记录          (新增)
```

## 视图文件

- `wizard/pricing_change_wizard_views.xml` - 定价修改向导视图
- `views/package_pricing_change_log_views.xml` - 变更记录视图
- `views/package_pricing_views.xml` - 修改后的定价视图（新增按钮和统计）
- `views/apollo_package_menus.xml` - 更新菜单结构

## 注意事项

1. **数据迁移**：现有定价数据不会自动生成历史记录，只有新的变更才会被记录
2. **权限要求**：需要套餐管理员权限才能修改定价
3. **只读限制**：一旦设置为只读，直接编辑定价将无法工作，必须使用向导
4. **审计合规**：所有变更记录都是永久性的，符合审计要求

## 未来扩展

- 可以考虑添加定价审批流程
- 支持批量定价修改
- 添加定价变更通知机制
- 集成更多的统计分析功能
