# Apollo Package Management System

Apollo套餐权限管理系统是一个基于额度驱动的灵活套餐管理解决方案。

## 功能特性

### 🎯 核心功能
- **灵活的套餐配置**：支持无限扩展的套餐类型
- **额度驱动权限**：基于额度的统一权限检查逻辑
- **组织级别管理**：套餐绑定到组织，支持权限继承
- **个性化调整**：支持单独调整组织的额度和时长
- **完整的审计追踪**：记录所有操作历史

### 📊 管理功能
- **套餐管理**：创建和配置各种类型的套餐
- **额度定义**：定义系统中所有可能的额度类型
- **订阅管理**：管理组织的套餐订阅情况
- **使用监控**：实时跟踪额度使用情况
- **报表分析**：提供详细的使用统计和分析

### 🔧 技术特点
- **配置化权限管理**：无需硬编码，完全通过配置实现
- **扩展套餐支持**：天然支持套餐扩展和升级机制
- **多种调整类型**：支持增加、设置、倍数等多种额度调整方式
- **临时性调整**：支持设置调整的有效期
- **Odoo风格界面**：直观易用的管理界面

## 数据模型

系统包含9个核心数据表：

1. **功能模块表** (`apollo.feature.module`) - 定义系统功能模块
2. **额度定义表** (`apollo.quota.definition`) - 定义所有额度类型
3. **套餐表** (`apollo.package`) - 主套餐信息
4. **套餐额度表** (`apollo.package.quota`) - 套餐额度关联
5. **套餐定价表** (`apollo.package.pricing`) - 套餐价格管理
6. **组织订阅表** (`apollo.organization.package.subscription`) - 组织订阅记录
7. **额度调整表** (`apollo.organization.quota.adjustment`) - 个性化额度调整
8. **订阅延长表** (`apollo.organization.subscription.extension`) - 订阅时长延长
9. **额度使用表** (`apollo.organization.quota.usage`) - 额度使用跟踪

## 权限体系

### 用户组
- **套餐管理员**：完全管理权限
- **套餐经理**：订阅和调整管理权限
- **套餐销售**：查看和创建订阅权限
- **套餐客服**：基础调整和查看权限
- **套餐用户**：查看自己组织信息权限

### 权限检查逻辑
```python
# 检查功能访问权限
permission_service = env['apollo.package.permission.service']
access_result = permission_service.check_feature_access(user_id, 'academy')

# 检查额度可用性
quota_result = permission_service.check_quota_permission(user_id, 'hanna_conversations', 1)

# 消费额度
consume_result = permission_service.consume_user_quota(user_id, 'hanna_conversations', 1)
```

## 额度驱动权限模式

### 核心思想
1. **额度定义**：预先定义所有可能的额度类型
2. **套餐配置**：套餐通过关联额度来定义能力
3. **权限检查**：功能权限通过检查额度来决定
4. **灵活扩展**：新增套餐类型只需配置额度组合

### 权限判断规则
- **额度启用 (is_active=True) 且额度值 > 0** = 有权限/可使用
- **额度禁用 (is_active=False) 或额度值 = 0** = 无权限/不可使用
- **功能权限**：通常设为1（有权限）或0（无权限）
- **数量额度**：设为具体可用数量

## 安装和配置

### 依赖模块
- `base` - Odoo基础模块
- `apollo_account` - Apollo组织管理模块

### 安装步骤
1. 将模块放置在addons目录下
2. 更新应用列表
3. 安装Apollo Package Management模块
4. 配置用户权限组
5. 创建功能模块和额度定义
6. 配置套餐和定价

### 初始配置
1. **创建功能模块**：定义系统中的各个功能模块
2. **定义额度类型**：创建所需的额度定义
3. **配置套餐**：创建套餐并关联额度
4. **设置定价**：为套餐配置价格信息
5. **分配权限**：为用户分配适当的权限组

## 使用示例

### 创建企业套餐
```xml
<!-- 创建套餐 -->
<record id="enterprise_package" model="apollo.package">
    <field name="name">企业版套餐</field>
    <field name="package_code">ENT_12W</field>
    <field name="category">enterprise</field>
    <field name="duration_weeks">12</field>
</record>

<!-- 配置额度 -->
<record id="ent_sub_accounts" model="apollo.package.quota">
    <field name="package_id" ref="enterprise_package"/>
    <field name="quota_definition_id" ref="quota_sub_accounts"/>
    <field name="quota_limit">5</field>
    <field name="is_active">True</field>
</record>
```

### 为组织分配套餐
```python
# 创建订阅
subscription = env['apollo.organization.package.subscription'].create({
    'organization_id': organization.id,
    'package_id': package.id,
    'start_date': fields.Date.today(),
    'end_date': fields.Date.today() + timedelta(weeks=12),
})
```

### 调整组织额度
```python
# 增加额度
adjustment = env['apollo.organization.quota.adjustment'].create({
    'organization_id': organization.id,
    'quota_definition_id': quota_def.id,
    'adjustment_type': 'add',
    'adjustment_value': 1000,
    'reason': '客户投诉补偿',
})
```

## API服务

### 额度服务
- `get_organization_effective_quotas()` - 获取组织有效额度
- `check_quota_available()` - 检查额度可用性
- `consume_quota()` - 消费额度

### 权限服务
- `check_feature_access()` - 检查功能访问权限
- `check_quota_permission()` - 检查额度权限
- `consume_user_quota()` - 消费用户额度

## 扩展和定制

### 添加新的额度类型
1. 在额度定义中创建新的额度类型
2. 在相关套餐中配置新额度
3. 在代码中添加相应的权限检查

### 创建自定义套餐类型
1. 在套餐分类中添加新类型
2. 配置相应的额度组合
3. 设置定价策略

### 扩展权限检查逻辑
```python
# 自定义权限检查
class CustomPermissionService(models.AbstractModel):
    _inherit = 'apollo.package.permission.service'
    
    def check_custom_permission(self, user_id, custom_rule):
        # 实现自定义权限逻辑
        pass
```

## 维护和监控

### 定时任务
- 自动更新过期订阅状态
- 停用过期的额度调整
- 生成使用统计报告

### 监控指标
- 额度使用率
- 订阅到期提醒
- 超限使用警告
- 系统性能指标

## 支持和帮助

如有问题或需要技术支持，请联系Apollo技术团队。

---

**版本**: 18.0.1.0.0  
**作者**: Apollo Team  
**许可证**: LGPL-3
